IF OBJECT_ID('RC_ADM_CARTAO_PARC_MINIMA_PRC_FILIAL') IS NULL
BEGIN
	CREATE TABLE [dbo].[RC_ADM_CARTAO_PARC_MINIMA_PRC_FILIAL](
		[CD_EMP] [int] NOT NULL,
		[CD_FILIAL] [int] NOT NULL,
		[CD_PARC] [int] NOT NULL,
	 CONSTRAINT [PK_RC_ADM_CARTAO_PARC_MINIMA_PRC_FILIAL] PRIMARY KEY CLUSTERED 
	(
		[CD_EMP] ASC,
		[CD_FILIAL] ASC,
		[CD_PARC] ASC
	)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
	) ON [PRIMARY]

	ALTER TABLE [dbo].[RC_ADM_CARTAO_PARC_MINIMA_PRC_FILIAL]  WITH CHECK ADD  CONSTRAINT [FK_RC_ADM_CARTAO_PARC_MINIMA_PRC_FILIAL_PRC_FILIAL] FOREIGN KEY([CD_EMP], [CD_FILIAL])
	REFERENCES [dbo].[PRC_FILIAL] ([CD_EMP], [CD_FILIAL])
	ON UPDATE CASCADE ON DELETE CASCADE

	ALTER TABLE [dbo].[RC_ADM_CARTAO_PARC_MINIMA_PRC_FILIAL] CHECK CONSTRAINT [FK_RC_ADM_CARTAO_PARC_MINIMA_PRC_FILIAL_PRC_FILIAL]
	
	ALTER TABLE [dbo].[RC_ADM_CARTAO_PARC_MINIMA_PRC_FILIAL]  WITH CHECK ADD  CONSTRAINT [FK_RC_ADM_CARTAO_PARC_MINIMA_PRC_FILIAL_RC_ADM_CARTAO_PARC_MINIMA] FOREIGN KEY([CD_PARC])
	REFERENCES [dbo].[RC_ADM_CARTAO_PARC_MINIMA] ([CD_PARC])
	ON UPDATE CASCADE
	
	ALTER TABLE [dbo].[RC_ADM_CARTAO_PARC_MINIMA_PRC_FILIAL] CHECK CONSTRAINT [FK_RC_ADM_CARTAO_PARC_MINIMA_PRC_FILIAL_RC_ADM_CARTAO_PARC_MINIMA]

	CREATE UNIQUE INDEX [UK_RC_ADM_CARTAO_PARC_MINIMA_PRC_FILIAL_CD_FILIAL] ON [RC_ADM_CARTAO_PARC_MINIMA_PRC_FILIAL] ([CD_EMP], [CD_FILIAL])

	INSERT INTO
		RC_ADM_CARTAO_PARC_MINIMA_PRC_FILIAL (CD_EMP, CD_FILIAL, CD_PARC)
	SELECT 
		PRC_FILIAL.CD_EMP,
		PRC_FILIAL.CD_FILIAL,
		MAX(RC_ADM_CARTAO_PARC_MINIMA.CD_PARC)
	FROM
		PRC_FILIAL
		INNER JOIN RC_ADM_CARTAO_PARC_MINIMA ON
			PRC_FILIAL.CD_EMP = RC_ADM_CARTAO_PARC_MINIMA.CD_EMP
	GROUP BY
		PRC_FILIAL.CD_EMP,
		PRC_FILIAL.CD_FILIAL

END

GO
